
import cv2 as cv
import numpy as np


class MyFeatureDetector:
    def __init__(self, detector = cv.ORB):
        self.myFeatureDetectorType = detector
        self.myFeatureDetector = None
        self.myFeatures = None
        self.changeFeatureDetector(detector) 


    def changeFeatureDetector(self, detectorType):
        # First release the previous detector
        if self.myFeatureDetector is not None:
            self.myFeatureDetector.release()

        # and we store the method
        self.myFeatureDetectorType = detectorType

        # Depending on the detector type we will create the correponsding corner detector
        if detectorType == cv.ORB:
            # TODO: create and store detector using cv.ORB_create()
            pass # TODO: remove this line
            
        # TODO: Add other detectors

    def setImage(self, image):
        self.image = image

    def getImage(self):
        return self.image

    def detectFeatures(self):
        self.myFeatures = self.myFeatureDetector.detect(self.image)
    
    # Displaying features in the image (and returning a clone of this image)
    def displayFeatures(self, image):
        # Clone the image
        image = image.copy()

        # Turn it in color
        image = cv.cvtColor(image, cv.COLOR_GRAY2BGR)

        # Draw the features
        for feature in self.myFeatures:
            # Draw detected features
            cv.circle(image, (int(feature.pt[0]), int(feature.pt[1])), 3, (0, 255, 0), -1)

        return image

    def getFeatures(self):
        return self.myFeatures

    def getFeatureDetector(self):
        return self.myFeatureDetector

    def getFeatureDetectorName(self):
        if self.myFeatureDetectorType == cv.ORB:
            return "ORB"
        if self.myFeatureDetectorType == cv.BRISK:
            return "BRISK"
        if self.myFeatureDetectorType == cv.AKAZE:
            return "AKAZE"
        if self.myFeatureDetectorType == cv.KAZE:
            return "KAZE"
        if self.myFeatureDetectorType == cv.SIFT:
            return "SIFT"
        if self.myFeatureDetectorType == cv.FAST:
            return "FAST"
        if self.myFeatureDetectorType == cv.GFTT:
            return "GFTT"
        if self.myFeatureDetectorType == cv.MSER:
            return "MSER"
        return "UNKNOWN"